package sehnsucht;
import javax.swing.*;
import java.util.*;
/**
 * <p>berschrift: </p>
 * <p>Beschreibung: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Organisation: </p>
 * @author Erik Wegner
 * @version 1.0
 */

public class Rechner extends Thread {
  private boolean running;
  private JLabel ausgabeLabel;
  private String tag, monat, jahr, stunde, minute;
  private GregorianCalendar ziel;
  private long zielmillis;

  public Rechner(JLabel ausgabe) {
    super();
    this.ausgabeLabel = ausgabe;
    this.running = false;
    this.ziel = new GregorianCalendar();
  }

  public void setzeZielZeit(String tag, String monat, String jahr, String stunde, String minute) {
    this.tag = tag;
    this.monat = monat;
    this.jahr = jahr;
    this.stunde = stunde;
    this.minute = minute;
    this.uebernimmWerte();
  }

  private int wandle(String s) {
    int r=0;
    try {
      int tr = Integer.parseInt(s);
      r = tr;
    } catch (NumberFormatException e) {
      e.printStackTrace();
    }
    return r;
  }

  private void uebernimmWerte() {
    int zieltag, zielmonat, zieljahr, zielminute, zielstunde;
    zieltag = this.wandle(this.tag);
    zielmonat = this.wandle(this.monat) -1 + GregorianCalendar.JANUARY;
    zieljahr = this.wandle(this.jahr);
    if (zieljahr < 100) zieljahr += 2000;
    zielminute = this.wandle(this.minute);
    zielstunde = this.wandle(this.stunde);
    ziel.set(zieljahr, zielmonat, zieltag, zielstunde, zielminute);
    this.zielmillis = ziel.getTimeInMillis();
  }

  public void ende() {
    this.running = false;
  }

  public void startThread() {
    if(!this.running) {this.start();}
  }

  public void run() {
    if (!running) {
      this.running = true;
      GregorianCalendar jetzt;
      long difmillis, secs, m, h, d;
      StringBuffer sb = new StringBuffer("");
      while (this.running) {
        jetzt = (GregorianCalendar)GregorianCalendar.getInstance();
        difmillis = zielmillis - jetzt.getTimeInMillis();
        secs = difmillis / 1000;
        sb.setLength(0);
        if (secs > 0) {
          d = secs / (60 * 60 * 24);
          secs = secs - (d * 60 * 60 * 24);
          h = secs / (60 * 60);
          secs = secs - (h * 60 * 60);
          m = secs / 60;
          sb.append("noch ");
          sb.append(d);
          sb.append(" Tag" + (d == 1 ? "" : "e") + ", ");
          sb.append(h);
          sb.append(" Stunde" + (h == 1 ? "" : "n") + " und ");
          sb.append(m);
          sb.append(" Minute" + (m == 1 ? "" : "n") + ".");
        } else {
          sb.append("Termin wurde erreicht!");
        }
        this.ausgabeLabel.setText(sb.toString());
        try {
          sleep(500);
        } catch (InterruptedException e) {}
      }
    }
  }

}