// Primzahlgeburtstag
//
// Das Programm berechnet den letzten und den nchsten Tag,
// dessen Abstand in Tagen vom Geburtstag eine Primzahl ist.

#include <iostream>
#include <ctime>

#include "primgebprim.h"
#include "primgebdatum.h"

using namespace std;
int tag,monat,jahr;
tm *tm_geburtstag;
time_t time_geburtstag, time_jetzt;
long tage;
const int buffer_len = 26;
char buffer[buffer_len];

void intro() {
	cout << "Primzahlengeburtstag V1.02\n\n"
		<< "Das Programm berechnet, welches Alter Sie in Tagen haben\n"
		<< "und stellt dann fest, an welchem Tag in der Zukunft und an\n"
		<< "welchen Tag in der Vergangenheit diese Zahl eine Primzahl\n"
		<< "sein wird/wahr.\n\n";		
}

void abfrage_geburtstag() {
	cout << "Geben Sie Ihr Geburtsdatum ein...\n";
	cout << "  Tag = "; cin >> tag;
	cout << "Monat = "; cin >> monat;
	cout << " Jahr = "; cin >> jahr;
}

void ende() {
	delete( tm_geburtstag );
	cout << "\nAuf Wiedersehen.\n";
}

void fuelle_tm_geburtstag() {
	//Erzeuge und flle die "broken time"-Struktur
	tm_geburtstag = new tm;
	tm_geburtstag->tm_sec   = 1;
	tm_geburtstag->tm_min   = 0;
	tm_geburtstag->tm_hour  = 0;
	tm_geburtstag->tm_mday  = tag;
	tm_geburtstag->tm_mon   = monat - 1;
	tm_geburtstag->tm_year  = jahr - 1900;
	tm_geburtstag->tm_isdst = 0;	
	//Berechne die Anzahl Sekunden seit 1.1.1970
	time_geburtstag = mktime(tm_geburtstag);
}

int suche_primzahl(int startzahl, int delta) {
	int ergebnis = startzahl;
	while (!ist_primzahl(ergebnis)) ergebnis+=delta;
	return ergebnis;
}

//Errechne aus der Anzahl Sekunden t das Datum
//und stelle es im Format TT.MM.JJJJ dar
char *tage_zu_datum(long t) {		
	time_t time_ziel = time_geburtstag + t*60*60*24;
	tm *tm_ziel = localtime(&time_ziel);
	const char format[] = "%d.%m.%Y";
	strftime(&buffer[0], 
		buffer_len, 
		format, 
		tm_ziel);
	return &buffer[0];
}

void berechne_tage_heute() {
	//Uhrzeit jetzt
	time( &time_jetzt );
	long btage;
	tage = (long)(difftime(time_jetzt,time_geburtstag)/(60*60*24));
	cout << "Ihr Geburtstag ist ja schon " 
		<< tage 
		<< " Tage her.\nUnd trotzdem noch so gutaussehend?\n";
	btage = suche_primzahl(tage+1,1); 
	cout << "Nchste Tageszahl " << btage << ".\n";
	cout << "Das ist am " << tage_zu_datum(btage) << ".\n\n";
	btage = suche_primzahl(tage,-1);
	cout << "Letzte Tageszahl " << btage << ".\n";
	cout << "Das war am " << tage_zu_datum(btage) 
	<< (btage == tage ? " (das ist ja heute)" : "")
	<< ".\n";
}

void verarbeite_eingaben() {
	fuelle_tm_geburtstag();
	berechne_tage_heute();
}

int main( int argc, char *argv[] ) {
	intro();
	bool datum_falsch;
	do {
		abfrage_geburtstag();
		datum_falsch = !datum_ist_gueltig(tag, monat, jahr);
		if (datum_falsch) cout << "Ihr Datum ist ungltig. Bitte wiederholen Sie die Eingabe.\n";
	} while(datum_falsch);
	cout << "\n\nVielen Dank. Jezt rechne ich...\n\n";
	verarbeite_eingaben();
	ende();
	return 0;
}
