/*
 * Decompiled with CFR 0.152.
 */
package de.ewus.primgeb;

import java.util.Calendar;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class PrimgebLogik
extends Thread {
    private Calendar calgeb;
    private Calendar calheute;
    private boolean initZahlen = false;
    private boolean initAusgaben = false;
    private int tag;
    private int monat;
    private int jahr;
    private String tagS;
    private String monatS;
    private String jahrS;
    private JTextField[] felder = new JTextField[5];
    private JLabel lAusgabe;

    public void setAusgabeFelder(JTextField tfNextGebTage, JTextField tfNextGebDat, JTextField tfLastGebTage, JTextField tfLastGebDat, JTextField tfTagezahl, JLabel lAusgabe) {
        this.felder[0] = tfNextGebTage;
        this.felder[1] = tfNextGebDat;
        this.felder[2] = tfLastGebTage;
        this.felder[3] = tfLastGebDat;
        this.felder[4] = tfTagezahl;
        this.lAusgabe = lAusgabe;
        this.initAusgaben = true;
    }

    public void setValues(String tag, String monat, String jahr) {
        this.tagS = tag;
        this.monatS = monat;
        this.jahrS = jahr;
    }

    public void rechne() {
        if (this.initAusgaben) {
            this.start();
        } else {
            System.err.println("Programmiererfehler: Ausgabefelder nicht initialisiert.");
        }
    }

    private boolean rechneStringsInZahlen() {
        boolean ergebnis = false;
        this.initZahlen = false;
        String fehler = "";
        this.lAusgabe.setText(" ");
        try {
            fehler = "Tageseingabe fehlerhaft.";
            this.tag = Integer.parseInt(this.tagS);
            fehler = "Monatseingabe fehlerhaft.";
            this.monat = Integer.parseInt(this.monatS);
            fehler = "Jahreseingabe fehlerhaft.";
            this.jahr = Integer.parseInt(this.jahrS);
            fehler = "Datum ist ung\u00fcltig.";
            if (!this.teste_Datum()) {
                throw new NumberFormatException();
            }
            this.calgeb = Calendar.getInstance();
            this.calgeb.clear();
            this.calgeb.set(this.jahr, this.monat - 1, this.tag);
            ergebnis = true;
            this.initZahlen = true;
        }
        catch (NumberFormatException nfe) {
            this.lAusgabe.setText(fehler);
        }
        return ergebnis;
    }

    private boolean teste_Datum() {
        boolean ergebnis = false;
        if (this.monat > 0 && this.monat < 13 && this.tag > 0 && this.tag < 32) {
            switch (this.monat) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    ergebnis = true;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    ergebnis = this.tag < 31;
                    break;
                }
                case 2: {
                    ergebnis = this.tag < 29 || this.tag == 29 && (this.jahr % 4 == 0 && this.jahr % 100 != 0 || this.jahr % 4 == 0 && this.jahr % 400 == 0);
                }
            }
        }
        return ergebnis;
    }

    private boolean ist_primzahl(long zahl) {
        boolean ergebnis = true;
        boolean cont = true;
        cont = zahl % 2L != 0L;
        ergebnis = cont;
        long teiler = 3L;
        while (cont) {
            if (zahl % teiler == 0L) {
                cont = false;
                ergebnis = false;
            }
            if (!((double)(teiler += 2L) > Math.sqrt(zahl))) continue;
            cont = false;
        }
        return ergebnis;
    }

    private long findePrimzahl(long startzahl, long delta) {
        long ergebnis = startzahl;
        while (!this.ist_primzahl(ergebnis)) {
            ergebnis += delta;
        }
        return ergebnis;
    }

    public void run() {
        if (this.rechneStringsInZahlen()) {
            this.calheute = Calendar.getInstance();
            long altertage = (this.calheute.getTimeInMillis() - this.calgeb.getTimeInMillis()) / 86400000L;
            this.felder[4].setText("" + altertage);
            long nextAltertage = this.findePrimzahl(altertage + 1L, 1L);
            this.felder[0].setText("" + nextAltertage);
            Calendar caltemp = (Calendar)this.calgeb.clone();
            caltemp.add(6, (int)nextAltertage);
            this.felder[1].setText(caltemp.get(5) + "." + (caltemp.get(2) + 1) + "." + caltemp.get(1));
            caltemp = null;
            long lastAltertage = this.findePrimzahl(altertage, -1L);
            this.felder[2].setText("" + lastAltertage);
            caltemp = (Calendar)this.calgeb.clone();
            caltemp.add(6, (int)lastAltertage);
            this.felder[3].setText(caltemp.get(5) + "." + (caltemp.get(2) + 1) + "." + caltemp.get(1));
            caltemp = null;
        }
    }
}

